var calleCorrecta=true;

jQuery(document).ready(function () {

	if ($("#docPorVisita").text() != ""){
		$("#btn_AdjuntarDocumentoPorVisita").hide();
		$("#btn_EliminarDocumentoPorVisita").show();
	} else {
		$("#btn_AdjuntarDocumentoPorVisita").show();
		$("#btn_EliminarDocumentoPorVisita").hide();
	}
	
	$("#btn_AdjuntarDocumentoPorVisita").click(function(){
		fn_adjuntarDocumento($("#divAdjuntarDocumento"), "docPorVisita", $("#btn_AdjuntarDocumentoPorVisita"), $("#btn_EliminarDocumentoPorVisita"));
	});		

	$("#btn_EliminarDocumentoPorVisita").click(function(){
		fn_eliminarDocumento($("#divAdjuntarDocumento"), "docPorVisita", $("#btn_AdjuntarDocumentoPorVisita"), $("#btn_EliminarDocumentoPorVisita"));
	});		

	 if(!estadoCierreRealizado && esUsuarioOsalanTer){
		//Botonera guardar datos de Osalan
		$("#guardarDatOsalan_toolbar").rup_toolbar({
			buttons:
				[{id:"Guardar", i18nCaption:$.rup.i18n.app.botones.Guardar, left:true,click: modificarDatosOsalan}]
		});
		
		//Cargar combos
		cargarCombos();
		cargarCombosTrabajo();
		
		recargarTablaVisitas=function(){
			$("#visitas").rup_table("reloadGrid", false);
		};
		
		$("#visitas").rup_table({
			url: $.rup.CTX_PATH +"ab03b58t00/buscarVisitas",
			colNames: [
			    "",
			    "",
				$.rup.i18n.app.visitas.fechaHora,
				$.rup.i18n.app.visitas.incumplimineto,
				$.rup.i18n.app.visitas.informe			
			],
			colModel: [
				{ 	name: "id058", 
					align: "left", 
					width: 250, 
					fixed: false, 
					hidden: true, 
					resizable: true, 
					sortable: true
				},
				{ 	name: "id014", 
					align: "left", 
					width: 250, 
					fixed: false, 
					hidden: true, 
					resizable: true, 
					sortable: true
				},
				{ 	name: "fechaHora058Str",
					align: "left", 
					width: 300, 
					editable: true,
					fixed: false, 
					hidden: false,
					resizable: true, 
					sortable: true
				},	
				{ 	name: "incumplimiento058", 
					index: "incumplimiento058", 
					editable:true, 
					width: 300, 
					edittype: "checkbox",
					formatter: "checkbox",
					align: "center",
					editoptions: {
						value:"S:N"
					},
					searchoptions:{
						rupType: "combo",
						source : [
						   {label: "Si", value:"S"},
						   {label: "No", value:"N"}
						]
					}
				},
				{ 	name: "oiddocvisita058",
					align: "left", 
					width: 300, 
					editable: true,
					fixed: false, 
					hidden: false,
					resizable: true, 
					sortable: true,
					formatter:function (cellval, opts, rwd, act) {
						if (rwd.oiddocvisita058 != null){
							return ("<a href=\"../../../../../../../../documento/uploadDokusi?oid="+rwd.oiddocvisita058+"\">"+$.rup.i18n.app.expedientes.docVisita+"</a>");
						} else {
							return "";
						}
					}
				}
				
	        ],
	        model:"Ab03b58t00",
	        usePlugins:[
	            "formEdit",
	    		"feedback",
	    		"toolbar",
	        	"fluid"
	        ],
	        fluid: {
	        	baseLayer: "seccionTrabajadores"
	        },
	        feedback:{
	    		config:{
	    			block: false
	    		}
	    	},
	        core: {	
	        	showOperations: {
		    		'add': false,
		    		'edit': false,
		    		'clone': false,
		    		'delete': true
	    		}
	        },
	        formEdit:{
				fillDataMethod: "clientSide",
				deleteOptions: {
					ajaxDelOptions: {
						afterDelete: recargarTablaVisitas
					}
				}
	        },
			primaryKey: "id058",
			sortname: "id058",
			sortorder: "asc",
			loadOnStartUp: true
		});
		
		$("#visitas").on("rupTable_beforeEditRow", 
			function(editOptions, selectedRow){
				return false ;
			}
		);
		
		
		$("#trabajadores").rup_table({
			url: $.rup.CTX_PATH +"ab03b32t00/buscarTrabajadoresInicio/"+$("#id056").val(),
			colNames: ["",
			    "",
			    "",
				$.rup.i18n.app.trabajadores.numDocumento,
				$.rup.i18n.app.trabajadores.nombre,
				$.rup.i18n.app.trabajadores.apellido1,
				$.rup.i18n.app.trabajadores.apellido2,
				$.rup.i18n.app.trabajadores.numSegSocial,
				$.rup.i18n.app.trabajadores.fechaAptitud,
				$.rup.i18n.app.trabajadores.titulaciones
			],
			colModel: [
				{ 	name: "id063", 
					align: "left", 
					width:70, 
					editable: false, 
					fixed: false, 
					hidden: true
				},
				{ 	name: "idEmpresa047", 
					align: "left", 
					width:70, 
					editable: false, 
					fixed: false, 
					hidden: true
				},
				{ 	name: "tipodoc032", 
					align: "left", 
					width:70, 
					editable: true,
					editableOnEdit:false,
					fixed: false, 
					hidden: true,
					sortable:true
				},
				{ 	name: "nif032",
					align: "left", 
					width: 90, 
					editable:true, 
					editableOnEdit:false,
					fixed: false, 
					hidden: false, 
					sortable: true,
					formatter: ab03bUtils.tabla.formatterNifUpperCase
				},
				{ 	name: "nombre032", 
					align: "left", 
					width: 90, 
					editable: true, 
					fixed: false, 
					hidden: false, 
					sortable: true
				},
				{ 	name: "apellido1032", 
					align: "left", 
					width: 130, 
					editable: true, 
					fixed: false, 
					hidden: false, 
					sortable: true
				},
				{ 	name: "apellido2032", 
					align: "left", 
					width: 130, 
					editable: true, 
					fixed: false, 
					hidden: false, 
					sortable: true
				},
				{ 	name: "nss032", 
					align: "left", 
					width: 120, 
					editable: true, 
					fixed: false, 
					hidden: false, 
					sortable: true
				},
				{ 	name: "fechaAptitud032", 
					align: "left", 
					width: 100, 
					editable: true, 
					fixed: false, 
					hidden: false, 
					sortable: true
				},
				{ 	name: "titulaciones032", 
					align: "left", 
					width: 180, 
					editable: true, 
					fixed: false, 
					hidden: false, 
					sortable: true
				}
		    ],
		    model:"Ab03b63v00trabinicio",
		    usePlugins:[
				"feedback",
				"toolbar",
		    	"fluid",
		    	"formEdit"
		    ],
		    fluid: {
		    	baseLayer: "seccionTrabajadores"
		    },
		    feedback:{
				config:{
					block: false
				}
			},
			core: {	
		    	showOperations: {
		    		'add': true,
		    		'edit': true,
		    		'clone': false,
		    		'delete': true
				}
		    },	
		    primaryKey: "id063",
			sortname: "id063",
			sortorder: "asc",
			loadOnStartUp: true
		});		
	 }else{
		 bloqueaCampos();
		 
		//Cargar combos
		cargarCombosDes();
		
		$("#visitas").rup_table({
			url: $.rup.CTX_PATH +"ab03b58t00/buscarVisitas",
			colNames: [
			    "",
			    "",
				$.rup.i18n.app.visitas.fechaHora,
				$.rup.i18n.app.visitas.incumplimineto,
				$.rup.i18n.app.visitas.informe			
			],
			colModel: [
				{ 	name: "id058", 
					align: "left", 
					width: 250, 
					fixed: false, 
					hidden: true, 
					resizable: true, 
					sortable: true
				},
				{ 	name: "id014", 
					align: "left", 
					width: 250, 
					fixed: false, 
					hidden: true, 
					resizable: true, 
					sortable: true
				},
				{ 	name: "fechaHora058Str",
					align: "left", 
					width: 300, 
					editable: true,
					fixed: false, 
					hidden: false,
					resizable: true, 
					sortable: true
				},	
				{ 	name: "incumplimiento058", 
					index: "incumplimiento058", 
					editable:true, 
					width: 300, 
					edittype: "checkbox",
					formatter: "checkbox",
					align: "center",
					editoptions: {
						value:"S:N"
					},
					searchoptions:{
						rupType: "combo",
						source : [
						   {label: "Si", value:"S"},
						   {label: "No", value:"N"}
						]
					}
				},
				{ 	name: "oiddocvisita058",
					align: "left", 
					width: 300, 
					editable: true,
					fixed: false, 
					hidden: false,
					resizable: true, 
					sortable: true,
					formatter:function (cellval, opts, rwd, act) {
						if (rwd.oiddocvisita058 != null){
							return ("<a href=\"../../../../../../../../documento/uploadDokusi?oid="+rwd.oiddocvisita058+"\">"+rwd.oiddocvisita058+"</a>");
						} else {
							return "";
						}
					}
				}
				
	        ],
	        model:"Ab03b58t00",
	        usePlugins:[
	    		"feedback",
	        	"fluid"
	        ],
	        fluid: {
	        	baseLayer: "seccionTrabajadores"
	        },
	        feedback:{
	    		config:{
	    			block: false
	    		}
	    	},
	        core: {	
	        	showOperations: {
		    		'add': false,
		    		'edit': false,
		    		'clone': false,
		    		'delete': false
	    		}
	        },
			primaryKey: "id058",
			sortname: "id058",
			sortorder: "asc",
			loadOnStartUp: true
		});
		
		$("#documentoPorVisita").hide();
		$("#visitas_Button").hide();
	 }
	 
	 $("#datosOsalan_form").rup_validate({
			feedback:$("#tramitacion_feedback"),
			liveCheckingErrors: true,
			showFieldErrorAsDefault: true,
			showErrorsInFeedback: true,
			showFieldErrorsInFeedback: true,
			rules:{
				"provinciaTrabajo056":{required:true},
				"municipTrabajo056":{required:true},
				"calleTrabajo056":{required:true},
				"numeroTrabajo056":{required:true},
				"cpostalTrabajo056":{required:true, digits:true},
				"fechIniTrabajo056":{required:true, date:true},
				"duracionDias056":{required:true, digits:true},
				"previsionMca056":{required:true},
				"estimacionMca056":{required:true},
				"fechaHora058":{dateTime:true}
			}
		});
		
		$(".validateDecimal").bind('keypress',function(e){  
	        if(e.keyCode == '9' || e.keyCode == '16'){  
	              return;  
	         }  
	         var code;  
	         if (e.keyCode) code = e.keyCode;  
	         else if (e.which) code = e.which;
	         if (code == 8 || code == 46)  
	              return true;  
	         if (code < 48 || code > 57)  
	              return false;  
		 	}  
		); 
	
	$(".validateDecimal").on("paste", function(e) {
		var that = this;
		setTimeout(function() {
			that.value = that.value.replace(",", ".");
	        that.value = that.value.replace(/[^0-9\.]+/g, "");
	    }, 50);
	}); 
	
	$("#fechIniTrabajo056").rup_date({
		showSecond: false
	});
	
});



recargarTablaTrabajadores=function(){
	$("#trabajadores").rup_table("reloadGrid", false);
};



//Funcion que serializa la visita para ser enviado
function serializeDatosOsalan(){
	
	var numTipoTrabajos=$("#numTipoTrabajos").val();
	
	var tipoTrabajo = null;
	var listaTipoTrabajo = [];
	
	for (i=1;i<=numTipoTrabajos;i++){
		tipoTrabajo = $("#trabajo_"+i)[0].checked;
	
		if(tipoTrabajo==true){
			listaTipoTrabajo.push(i);
		}
	}
	$("#trabajosEjec059").val(listaTipoTrabajo);
	
	//Reemplazar la coma por el punto
	var estimacionMCA = $("#estimacionMca056").val();
	estimacionMCA = estimacionMCA.replace(",",".");
	$("#estimacionMca056").val(estimacionMCA);
	
	$("#fechIniTrabajo056Str").val($("#fechIniTrabajo056").val());
		
	return $("#datosOsalan_form").rup_form('formToJson');
}

function modificarDatosOsalan(){

	$("#tramitacion_feedback").rup_feedback("close");
	
	if(ab03bUtils.form.validate($("#datosOsalan_form"), $("#tramitacion_feedback"))){
		// Llamada ajax para guardar los datos de osalan
		$.rup_ajax({
			url:  $.rup.CTX_PATH +"ab03b56t00/guardarDatosOsalan",
			type: "POST",
			data: JSON.stringify(serializeDatosOsalan()),
			dataType: 'json',
			contentType: 'application/json',
			success: function (mapaRespuesta){
				ab03bUtils.feedback.pintarFeedback($.rup.i18nParse($.rup.i18n.app,"mensajes.okGenerico"),  "ok",$("#tramitacion_feedback"));
			},
			error: function(error){
				pintarFeedbackError(error.responseText, $("#tramitacion_feedback"));
			},
			complete: function() {
				ab03bUtils.util.desBloquearInterfaz();
			}
		});
	}
}

function cargarCombos(){
	
	$("#id041Material").rup_combo({
		source:  $.rup.CTX_PATH +"ab03b41t00/comboTipoMaterial",
		sourceParam : {label:"desc"+$.rup_utils.capitalizedLang(), value:"code", style:"css"},
		selected:$("#id041").val(),
		width:250,
		rowStriping:true,
		inputText:true,
		ordered:true
	});
	
	$("#id054Actividad").rup_combo({
		source:  $.rup.CTX_PATH +"ab03b54t00/comboActividades",
		sourceParam : {label:"desc"+$.rup_utils.capitalizedLang(), value:"code", style:"css"},
		selected:$("#id054").val(),
		width:250,
		rowStriping:true,
		inputText:true,
		ordered:true
	});
	
	$("#id055SubActividad").rup_combo({
		source:  $.rup.CTX_PATH +"ab03b55t00/comboSubtipoActividad",
		sourceParam : {label:"desc"+$.rup_utils.capitalizedLang(), value:"code", style:"css"},
		selected:$("#id055").val(),
		width:250,
		rowStriping:true,
		inputText:true,
		ordered:true
	});
	
	$("#fechaHora058").rup_date({
		datetimepicker:true,
		showSecond: false
	});
}

function cargarCombosDes(){
	
	$("#id041Material").rup_combo({
		source:  $.rup.CTX_PATH +"ab03b41t00/comboTipoMaterial",
		sourceParam : {label:"desc"+$.rup_utils.capitalizedLang(), value:"code", style:"css"},
		selected:$("#id041").val(),
		width:250,
		rowStriping:true,
		inputText:true,
		ordered:true,
		disabled:true
	});
	
	$("#id054Actividad").rup_combo({
		source:  $.rup.CTX_PATH +"ab03b54t00/comboActividades",
		sourceParam : {label:"desc"+$.rup_utils.capitalizedLang(), value:"code", style:"css"},
		selected:$("#id054").val(),
		width:250,
		rowStriping:true,
		inputText:true,
		ordered:true,
		disabled:true
	});
	
	$("#id055SubActividad").rup_combo({
		source:  $.rup.CTX_PATH +"ab03b55t00/comboSubtipoActividad",
		sourceParam : {label:"desc"+$.rup_utils.capitalizedLang(), value:"code", style:"css"},
		selected:$("#id055").val(),
		width:250,
		rowStriping:true,
		inputText:true,
		ordered:true,
		disabled:true
	});
	
	$("#fechaHora058").rup_date({
		datetimepicker:true,
		showSecond: false,
		disabled:true
	});
}

//Funcion que serializa la visita para ser enviado
function serializeVisita(){
	
	//var fechIniTrabajo056=$("#fechIniTrabajo056").val();
	//$("#fechTrab056").val(fechIniTrabajo056);

	var fVisita058=$("#fechaHora058").val();
	$("#fechaHora058Str").val(fVisita058);
	
	var incumplimiento058 = $("#incumplimientoVisita058")[0].checked;
	$("#incumplimiento058").val(incumplimiento058);
	
	//$("#oiddocvisita058").val($("#docPorVisita").text());
	
	return $("#datosOsalan_form").rup_form('formToJson');
}

function anadirVisita(){

	$("#tramitacion_feedback").rup_feedback("close");
	$("#visitas_feedback").rup_feedback("close");
	
	if($("#fechaHora058").val()!=""){
		// Llamada ajax para añadir la visita
		$.rup_ajax({
			url:  $.rup.CTX_PATH +"ab03b58t00/anadir",
			type: "POST",
			data: JSON.stringify(serializeVisita()),
			dataType: 'json',
			contentType: 'application/json',
			success: function (mapaRespuesta){
				ab03bUtils.feedback.pintarFeedback($.rup.i18nParse($.rup.i18n.app,"mensajes.okGenerico"),  "ok",$("#visitas_feedback"));
				$("#visitas").trigger("reloadGrid");
				$("#fechaHora058").val("");
				$("#incumplimientoVisita058")[0].checked = false;
				$("#docPorVisita").text("");
				$("#btn_AdjuntarDocumentoPorVisita").show();
				$("#btn_EliminarDocumentoPorVisita").hide();
			},
			error: function(error){
				pintarFeedbackError(error.responseText, $("#tramitacion_feedback"));
			},
			beforeSend : function() {
				if(!ab03bUtils.form.validate($("#datosOsalan_form"), $("#tramitacion_feedback"))){
					return false;
				}
			},
			complete: function() {
				ab03bUtils.util.desBloquearInterfaz();
			}
		});
	}else{
		ab03bUtils.feedback.pintarFeedbackError($.rup.i18n.app.mensajes.errorFVisita,  $("#visitas_feedback"));
	}
}

function bloqueaCampos() {

	 $("form :input").attr("readonly", "readonly");	 
	 $("form :checkbox").attr("disabled", "disabled");
	 $("#previsionMca056").attr("readonly", "readonly");
	 $("#estimacionMca056").attr("readonly", "readonly");
	 
	 $("#incumplimientoVisita058").attr("readonly", "readonly");
	 $("form input[id=visitas_Button]").attr("readonly", "readonly");
	 
	//Pestaña 1: Datos de la empresa
	$("#provinciaTrabajo056").rup_combo({
		source:  $.rup.CTX_PATH + "ab03bNora/comboProvincia",
		sourceParam : {label:"desc"+$.rup_utils.capitalizedLang(), value:"code", style:"css"},
		selected:$("#provTrabajo").val(),
		width:150,
		rowStriping:true,
		inputText:true,
		ordered:true,
		disabled:true
	});
	
	$('#municipTrabajo056').rup_combo({
		source : "/ab03bAmiantoWar/ab03bNora/comboMunicipioTrabajo056",
		sourceParam : {label:"desc"+$.rup_utils.capitalizedLang(), value:"code", style:"css"},
		selected:$("#muniTrabajo").val(),
		width: 300,
		rowStriping:true,
		inputText:true,
		ordered:true,
		disabled:true,
		parent:["provinciaTrabajo056"],
		change:function(){
			cargaAutocompleteCalle();
		},
		loadFromSelect: true
	});
		
	$('#calleTrabajo056').attr("readonly", true);
	$('#numeroTrabajo056').attr("readonly", true);
	$('#pisoTrabajo056').attr("readonly", true);
	$('#letraTrabajo056').attr("readonly", true);
	$('#cpostalTrabajo056').attr("readonly", true);

	$("#fechIniTrabajo056").rup_date({
		disabled:true
	});
	
	$('#duracionDias056').attr("readonly", true);
	 
}

function cargarCombosTrabajo(){
	
	//Pestaña 1: Datos de la empresa
	$("#provinciaTrabajo056").rup_combo({
		source:  $.rup.CTX_PATH + "ab03bNora/comboProvincia",
		sourceParam : {label:"desc"+$.rup_utils.capitalizedLang(), value:"code", style:"css"},
		selected:$("#provTrabajo").val(),
		width:150,
		rowStriping:true,
		inputText:true,
		ordered:true
	});
	
	$('#municipTrabajo056').rup_combo({
		source : "/ab03bAmiantoWar/ab03bNora/comboMunicipioTrabajo056",
		sourceParam : {label:"desc"+$.rup_utils.capitalizedLang(), value:"code", style:"css"},
		selected:$("#muniTrabajo").val(),
		width: 300,
		rowStriping:true,
		inputText:true,
		ordered:true,
		parent:["provinciaTrabajo056"],
		change:function(){
			cargaAutocompleteCalle();
		},
		loadFromSelect: true
	});
}

function cargaAutocompleteCalle(){

	// Autocomplete calle
	calleCorrecta=false;
	
	var urlSource = "/ab03bAmiantoWar/ab03bNora/comboCalle?";
	$("#calleTrabajo056").rup_autocomplete({
		source:urlSource+"prov="+$("#provinciaTrabajo056").val()+"&mun="+$("#municipTrabajo056").val(),
		sourceParam:{
			label:"ds_o",
			value:"id"
		},
		minLength: 1,
		combobox: false,
		select: function(){
			calleCorrecta=true;
			
		}
	});
	
	recuperarNomCalle($("#calleTrabajo056").val(),"calleTrabajo056");
	
}


function recuperarNomCalle(codCalle,variable){

	if(codCalle!='' && codCalle!='0'){
	
		$.ajax({
			type : "GET",
			url : "/ab03bAmiantoWar/ab03bNora/busquedaCallePorId/"+ codCalle + "?R01HNoPortal=true",
			dataType : "json",
			error : function(jqXHR, textStatus, errorThrown) {
				$("#calleTrabajo056").val(codCalle);
			},
			success : function(data, textStatus, jqXHR) {
				$("#"+variable).rup_autocomplete("set", codCalle, data.desc);
			}
		});
	}
}

